 //************************************************************
//  Copyright (c) Ԫ΢޹˾
//	ļ	: main.c
//			: Jamie
//	ģ鹦	: ˮλ+ذDEMO
//  :
// 	汾		: 
//              :  
//*************************************************************
#include "h\SC92R425_C.H"
#include "h\data_type.h"
#include "lib\SensorMethod.h"
#include "h\uart.h"

#define  __DEBUG__				//򿪴˿ؽˮλ

#ifdef   __DEBUG__
uchar  UartSendBuf[6]={ 0};
uchar i,ChannlCount=5;
#endif

//*****************ȫֱ***************************************************
INT32U exKeyValueFlag = 0;		//ǰְ־
INT32U WatL_exKeyValueFlag = 0;		//ǰְ־

INT16U  AdjustCount = 0;		//ʱʱ
BOOL   NotWaterAdjust = 0;		//ˮУ׼־

INT8U  gTkIsValid = 0; 			//Ч־
INT8U  exKeyValue = 0;			//ǰְֵ
INT8U  WatL_exKeyValue = 0;			//ǰְֵ
INT8U  KeyValue = 0;			//ֵ

unsigned int Key_CNT = 0;		//ִˮУ׼
 /**************************************************
*ƣvoid TimerInit(void) 
*ܣʱʼ
*ڲvoid
*ڲvoid
**************************************************/
void TimerInit(void)
{
	TMCON |= 0x01;		//bit0: 0ΪFOSC/12,1ΪFOSO

	TMOD |= 0x01;                 //0000 0001;Timer0ùʽ1
	TL0 = (65536 - 32000)%256;    //ʱ䣺ʱΪFsys32000*1/Fsys=1ms;
	TH0 = (65536 - 32000)/256;
	TR0 = 0;
	ET0 = 1;//ʱ0
	TR0 = 1;//򿪶ʱ0
}
/**************************************************
*ƣvoid timer0()interrupt 1 
*ܣʱжϷ
*ڲvoid
*ڲvoid 
**************************************************/
void timer0()interrupt 1
{
	TL0 = (65536 - 32000)%256;    //ʱ䣺ʱΪFsys32000*1/Fsys=1ms;
	TH0 = (65536 - 32000)/256;
	if(NotWaterAdjust == 0)
	{
		AdjustCount++;
		if(AdjustCount>10000)
		{
			NotWaterAdjust = 1;		//ϵһʱNotWaterAdjustΪ0ʱ䵽ԺΪ1NotWaterAdjustΪ0ˮУ׼
		}		
	}			 	
}

void delay(INT16U t)
{
	INT16U i,j;
	for(i=0;i<t;i++)
		for(j=0;j<100;j++)
		{
			WDTCON  = 0x10;		
		}
}
 /**************************************************
*ƣvoid  Sys_Init(void) 
*ܣϵͳʼ
*ڲvoid
*ڲvoid  
**************************************************/
void  Sys_Init(void)
{	
	WDTCON  = 0x10;				    //1--1 -- 00    WDT,WDT0,WDT 524.288ms;¼ʱCode OptionѡENWDT
	//TKӦIOΪǿ1
	P0CON = 0xFF;
	P0PH  = 0xFF;
		
	P1CON = 0xFF;
	P1PH  = 0xFF;
	P2CON = 0xFF;
	P2PH  = 0xFF;
	P5CON = 0xFF;
	P5PH  = 0xFF;
	P0 = 0x00;
	P1 = 0x00;
	P2 = 0x00;
	P5 = 0x00; 	
	P1CON = 0xfb;	   
	EA = 1;						//ж	
    TimerInit(); 				//ʱʼ
}
/**************************************************
*ƣvoid ChangeTouchKeyvalue(void) 
*ܣתTKֵ
*ڲvoid
*ڲvoid
**************************************************/
void ChangeTouchKeyvalue(void)
{
	switch(exKeyValueFlag)
	{		
		case 0x00000001:exKeyValue = 1;break; 
	    default:exKeyValue = 0xff;break; 			
	}
		switch(WatL_exKeyValueFlag)
		{
			case 0x00080000://0x00001000
				WatL_exKeyValue = 1;
			break;
			
			case 0x000C0000://0x00001200
				WatL_exKeyValue = 2;
			break;
			
			case 0x000C4000://0x00001300
				WatL_exKeyValue = 3;
			break;
			
			case 0x000C6000://0x00001320
				WatL_exKeyValue = 4;
			break;
			
			default:
				WatL_exKeyValue = 0;
			break;
			
		}	
	switch(WatL_exKeyValue)				  //ݲͬĵλӦLED
	{		
		case 0:P0 = 0X00; P2 = 0X00;break; 
		case 1:P0 = 0X00; P2 = 0X02;break;
		case 2:P0 = 0X00; P2 = 0X03;break;
		case 3:P0 = 0X20; P2 = 0X03;break;
		case 4:P0 = 0X22; P2 = 0X03;break;
	    default:break; 			
	}
}
/**************************************************
*ƣvoid UpdateLcdBufFunc(void) 
*ܣʾݺ
*ڲvoid
*ڲvoid
**************************************************/
void UpdateLcdBufFunc(void)
{
	if(exKeyValue != 0xff)
	{
		if(gTkIsValid == 0)			//ǰֻһμ
		{		
			KeyValue=exKeyValue; 
            switch(KeyValue)
            {		
				case 1:						   //ϰϵ10ڳ3пˮУ׼У׼ɹͨȫLED˸ʾ
				Key_CNT++;
				if(!NotWaterAdjust)
				{
					if(Key_CNT>=50)
					{	
						Key_CNT = 0;
						if(NoWaterCalibration()==1)	  //ֻȷûˮʱܵˮУ׼˺1У׼ɹ0У׼ʧ
						{
							P0 = 0X22; P2 = 0X03;
							delay(2000);
							P0 = 0X00; P2 = 0X00;
							delay(2000);			  //У׼ɹͨƽ
							P0 = 0X22; P2 = 0X03;
							delay(2000);
							P0 = 0X00; P2 = 0X00;
							delay(2000);
							P0 = 0X22; P2 = 0X03;
							delay(2000);
							P0 = 0X00; P2 = 0X00;
							delay(2000);
							P0 = 0X22; P2 = 0X03;
							delay(2000);
							P0 = 0X00; P2 = 0X00;
							delay(2000);
							P0 = 0X22; P2 = 0X03;
							delay(2000);
							P0 = 0X00; P2 = 0X00;
						}
						else					  //У׼ʧܣLEDһֱ˸
						{
							while(1)
							{
							    WDTCON  = 0x10;	
								P0 = 0X22; P2 = 0X03;
								delay(2000);
								P0 = 0X00; P2 = 0X00;
								delay(2000);
							} 	
						}
						NotWaterAdjust = 1;	
						gTkIsValid = 1;	
					}
					
				} 
                default:exKeyValue = 0xff;break; 			
            }
		}						 	
	}
	else
	{
		gTkIsValid = 0;        
	}	
}
/**************************************************
*ƣvoid  Sys_Scan(void) 
*ܣɨTKʾ
*ڲvoid
*ڲvoid  
**************************************************/
void Sys_Scan(void)
{      				
	if(SOCAPI_TouchKeyStatus&0x80)	    //Ҫ2:  ɨһֱ־ǷTouchKeyScan()һҪݴ˱־λ
	 {	
		 
		SOCAPI_TouchKeyStatus &= 0x7f;	//Ҫ3: ־λ Ҫⲿ													    
		exKeyValueFlag = TouchKeyScan();//ݴ 
		WatL_exKeyValueFlag = WaterLeveDetectionScan();//ˮλ⺯
		
		#ifdef   __DEBUG__
		for(i=0;i<ChannlCount;i++)	 
		{			 		 		 			 
			UartSendBuf[0]=WatL_RawData[i]/10000+0X30;
			UartSendBuf[1]=WatL_RawData[i]%10000/1000+0X30;				 
			UartSendBuf[2]=WatL_RawData[i]%1000/100+0X30;
			UartSendBuf[3]=WatL_RawData[i]%100/10+0X30;
			UartSendBuf[4]=WatL_RawData[i]%10+0X30;
			UartSendBuf[5]=' ';
			Uart_SendString(UartSendBuf,6);  			  				 		  			
		}
			UartSendBuf[0]=WatL_exKeyValue/10000+0X30;
			UartSendBuf[1]=WatL_exKeyValue%10000/1000+0X30;				 
			UartSendBuf[2]=WatL_exKeyValue%1000/100+0X30;
			UartSendBuf[3]=WatL_exKeyValue%100/10+0X30;
			UartSendBuf[4]=WatL_exKeyValue%10+0X30;
			UartSendBuf[5]='\n';
			Uart_SendString(UartSendBuf,6); 
		
		#endif 
		
		ChangeTouchKeyvalue();   		//תֵ
        UpdateLcdBufFunc();         	//ˮУ 
		WL_TouchKeyRestart();				//һת																													 			
	}		  	   
}
/**************************************************
*ƣvoid main(void)								  
*ܣ
*ڲvoid
*ڲvoid  
**************************************************/
void main(void)
{
	Sys_Init();
	
	#ifdef   __DEBUG__
	Uart0_Init(32,38400);
	#endif
	//ˮλԼذʼ
	WL_TouchKeyInit();
		P0 = 0X22; P2 = 0X03;
		delay(2000);delay(2000);delay(2000);
		delay(2000);delay(2000);delay(2000);
		P0 = 0X00; P2 = 0X00;		
	while(1)
	{
		WDTCON  = 0x10;	
		Sys_Scan();
	} 
}
